package edu.uky.ai.lp.logic;

/**
 * Represents a specific thing in the logical universe.
 * 
 * @author Stephen G. Ware
 */
public class Constant extends Term {
	
	/**
	 * Constructs a new constant with the given name.
	 * 
	 * @param name the name
	 */
	public Constant(String name) {
		super(name);
	}

	@Override
	public Unifier unify(Formula other, Unifier unifier) {
		if(other instanceof Constant && this.equals(other))
			return unifier;
		else if(other instanceof Variable)
			return unifier.set((Variable) other, this);
		else
			return null;
	}
	
	@Override
	public Constant substitute(Unifier unifier) {
		return this;
	}
}
